#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//  Tunnel PlanesMod01.fsh    by    diatribes  
//https://www.shadertoy.com/view/M3GfWV
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract


float length2(vec2 p){
    float k = 20.;
    p = pow(abs(p), vec2(k));
    return pow(p.x + p.y, 1./k);
}

vec3 path1(float z) {
    return vec3(
        sin(z * .13) * 6.,
        sin(z * .08) * 6.,
        z
    );
}

vec3 path2(float z) {
    return vec3(
        sin(z * .13) * 3.,
        sin(z * .02) * 7.,
        z
    );
}

vec3 plasma(vec2 uv) {
    float t = iTime / 2.0;
    uv *= 10.;
    float r = distance(uv, vec2(sin(t), sin(t)));
    float g = distance(uv, vec2(0, 3.));
    float b = distance(uv, vec2(r, sin(t)*25.));
    float value = abs(sin(r+t) + sin(g+t) + sin(b+t) + sin(uv.x+t) + cos(uv.y+t));
    value = sqrt(value);
    r/=value*2.;
    g/=value*.5;
    b/=value;
    return vec3(r,g,b);
}

float scene(vec3 p, out vec3 rgb) {
    float d1 = length(p.xy - path1(p.z).xy);
    float d2 = length((p.xy - path2(p.z).xy).y) - 2.;
    float hit = min(d1,d2);
    rgb = hit == d1?plasma(sin(p.xz))*.1:plasma(sin(p.xy));
    return 2. - hit;
}

float raymarch(vec3 ro, vec3 rd, out vec3 rgb, bool skipRiver) {
   float d = 0.;
   for(float i = 0.; i < 100.; i++) {
        float step = scene(ro + rd * d, rgb);
        d += step;
        if(d > 100. || step < .001) {
            break;
        }
    }
    return d;
}

mat3 lookAt(vec3 origin, vec3 target, float roll) {
    vec3 rr = vec3(sin(roll), cos(roll), 0.0);
    vec3 ww = normalize(target - origin);
    vec3 uu = normalize(cross(ww, rr));
    vec3 vv = normalize(cross(uu, ww));
    return mat3(uu, vv, ww);
}

vec3 normal(vec3 p) {
    vec2 e = vec2(.01, 0);
    vec3 rgb;

    vec3 n = scene(p,rgb) - vec3(
        scene(p-e.xyy,rgb),
        scene(p-e.yxy,rgb),
        scene(p-e.yyx,rgb));

    return normalize(n);
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    vec3 rgb = vec3(1.);
    vec2 uv = -1.0 + 2.0*(fragCoord.xy/iResolution.xy);
	uv.x *= iResolution.x/iResolution.y;

	vec3 ro = path1(-iTime*13.);
	vec3 la = path1(ro.z-1.);

	vec3 rd = normalize(vec3(uv,1.)*lookAt(ro,la,0.));
	float d = raymarch(ro, rd, rgb, true);
    vec3 p = ro + rd * d;
    
    if (d < 100.) {
        float diffuse = max(dot(normal(p), normalize(ro-p)), .0);
        rgb *= diffuse;
        rgb *= 1./d;
    } else {
        vec3 red = vec3(.3, 0.00, 0.125);
        vec3 blue = vec3(0.0, 0.125, 0.5);
        rgb = mix(red.xyz, blue.xyz, uv.y);
    }

    fragColor = vec4(pow(rgb, vec3(.45)), 1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below 
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

